<?php
function fetchEmails($mailbox, $snoozedIDs = []) {
    $inbox = imap_open(
        "{" . $mailbox['imap_host'] . ":" . $mailbox['imap_port'] . "/imap/ssl}INBOX",
        $mailbox['username'],
        $mailbox['password']
    ) or die("IMAP fout: " . imap_last_error());

    $emails = imap_search($inbox, 'ALL');
    $results = [];

    if ($emails) {
        rsort($emails);
        foreach (array_slice($emails, 0, 30) as $num) {
            $header = imap_headerinfo($inbox, $num);
            $uid = imap_uid($inbox, $num);
            if (in_array($uid, $snoozedIDs)) continue;

            $results[] = [
                'uid' => $uid,
                'subject' => $header->subject ?? '(geen onderwerp)',
                'from' => $header->from[0]->mailbox . '@' . $header->from[0]->host,
                'date' => $header->date,
            ];
        }
    }

    imap_close($inbox);
    return $results;
}
?>
