<?php
session_start();
require_once 'config.php';

if (!$_SESSION['logged_in']) die("Niet ingelogd.");

$mailboxLabel = $_GET['mailbox'];
$uid = (int)$_GET['uid'];

if (!isset($mailboxes[$mailboxLabel])) {
    die("Onbekende mailbox.");
}

$mbox = $mailboxes[$mailboxLabel];
$imap = imap_open(
    "{" . $mbox['imap_host'] . ":" . $mbox['imap_port'] . "/imap/ssl}INBOX",
    $mbox['username'],
    $mbox['password']
) or die("Kan mailbox niet openen: " . imap_last_error());

$structure = imap_fetchstructure($imap, $uid, FT_UID);
$overview = imap_fetch_overview($imap, $uid, FT_UID)[0];
$message = imap_fetchbody($imap, $uid, 1, FT_UID);

// Simpele MIME-detectie
function decodeMessage($structure, $imap, $uid) {
    $body = '';
    if (!$structure->parts) {
        $body = imap_body($imap, $uid, FT_UID);
    } else {
        foreach ($structure->parts as $i => $part) {
            if ($part->subtype === 'PLAIN' || $part->subtype === 'HTML') {
                $body = imap_fetchbody($imap, $uid, $i+1, FT_UID);
                if ($part->encoding == 3) $body = base64_decode($body);
                elseif ($part->encoding == 4) $body = quoted_printable_decode($body);
                break;
            }
        }
    }
    return $body;
}

$body = decodeMessage($structure, $imap, $uid);

// Bijlagen verzamelen
$attachments = [];

if (isset($structure->parts) && count($structure->parts)) {
    for ($i = 0; $i < count($structure->parts); $i++) {
        $part = $structure->parts[$i];
        $isAttachment = false;

        if (isset($part->disposition) && in_array(strtolower($part->disposition), ['attachment', 'inline'])) {
            $isAttachment = true;
        }

        if ($isAttachment) {
            $filename = $part->dparameters[0]->value ?? 'bijlage-' . $i;
            $data = imap_fetchbody($imap, $uid, $i+1, FT_UID);
            if ($part->encoding == 3) $data = base64_decode($data);
            elseif ($part->encoding == 4) $data = quoted_printable_decode($data);
            file_put_contents("attachments/$filename", $data);
            $attachments[] = $filename;
        }
    }
}

imap_close($imap);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Mail bekijken</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<a href="dashboard.php">← Terug naar overzicht</a>
<h2><?= htmlspecialchars($overview->subject ?? '(Geen onderwerp)') ?></h2>
<p><strong>Van:</strong> <?= htmlspecialchars($overview->from) ?></p>
<p><strong>Datum:</strong> <?= htmlspecialchars($overview->date) ?></p>
<hr>
<div style="white-space:pre-wrap;"><?= htmlspecialchars($body) ?></div>
<?php if (!empty($attachments)): ?>
    <h3>Bijlagen</h3>
    <ul>
    <?php foreach ($attachments as $file): ?>
        <li><a href="attachments/<?= urlencode($file) ?>" download><?= htmlspecialchars($file) ?></a></li>
    <?php endforeach; ?>
    </ul>
<?php endif; ?>
</body>
</html>
