<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$companiesFile = '../data/companies.json';
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bedrijven</title>
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Bedrijven</h2>
    <a href="nieuw.php" class="btn btn-primary mb-3">Nieuw bedrijf</a>

    <?php if (count($companies) === 0): ?>
        <p>Er zijn nog geen bedrijven.</p>
    <?php else: ?>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Naam</th>
                    <th>Type</th>
                    <th>Acties</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($companies as $id => $c): ?>
                    <tr>
                        <td><?= htmlspecialchars($c['naam']) ?></td>
                        <td><?= htmlspecialchars($c['label']) ?></td>
                        <td>
                            <a href="bewerken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-warning">Bewerken</a>
                            <a href="verwijderen.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-danger">Verwijderen</a>
                            <a href="bekijken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-info">Details</a>
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    <?php endif ?>
</div>
</body>
</html>
