<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$dealsFile = '../data/deals.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';

$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

// Filters ophalen
$stadiumFilter = $_GET['stadium'] ?? '';
$zoekterm = trim($_GET['zoek'] ?? '');

// Filters toepassen
if ($stadiumFilter) {
    $deals = array_filter($deals, fn($d) => $d['stadium'] === $stadiumFilter);
}
if ($zoekterm !== '') {
    $deals = array_filter($deals, fn($d) => stripos($d['type'], $zoekterm) !== false);
}

// Sorteren op sluitdatum
uasort($deals, function ($a, $b) {
    return strtotime($a['sluitingsdatum']) <=> strtotime($b['sluitingsdatum']);
});
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <title>Deals</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Deals</h2>
    <a href="nieuw.php" class="btn btn-primary mb-3">Nieuwe deal</a>

    <!-- FILTERFORMULIER -->
    <form method="get" class="row g-2 mb-4">
        <div class="col-md-4">
            <label for="stadium" class="form-label">Filter op stadium:</label>
            <select name="stadium" id="stadium" class="form-select">
                <option value="">— Alle —</option>
                <?php
                $stadia = [
                    "Suspect", "Lead", "Prospect", "Hot Prospect",
                    "Relatie - Toesturen factuur",
                    "Relatie - Gesloten, gewonnen",
                    "Relatie - Gesloten, verloren",
                    "Relatie - Postponed"
                ];
                foreach ($stadia as $s) {
                    $sel = ($stadiumFilter === $s) ? 'selected' : '';
                    echo "<option value=\"$s\" $sel>$s</option>";
                }
                ?>
            </select>
        </div>

        <div class="col-md-4">
            <label for="zoek" class="form-label">Zoeken op type:</label>
            <input type="text" name="zoek" id="zoek" class="form-control" value="<?= htmlspecialchars($zoekterm) ?>">
        </div>

        <div class="col-md-4 d-flex align-items-end">
            <button type="submit" class="btn btn-primary me-2">Filter toepassen</button>
            <a href="index.php" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <?php if (count($deals) === 0): ?>
        <p>Er zijn nog geen deals.</p>
    <?php else: ?>
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Bedrijf</th>
                   <th>Bedrag</th>
                    <th>Opmerking</th>
                    <th>Stadium</th>
                    <th>Type</th>
                    <th>Sluitdatum</th>
                    <th>Contact</th>
                    <th>Acties</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($deals as $id => $d): ?>
                    <tr>
                        <td><?= isset($companies[$d['company_id']]) ? htmlspecialchars($companies[$d['company_id']]['naam']) : '—' ?></td>
                        <td>
                            <?= isset($d['bedrag']) && is_numeric($d['bedrag']) 
                                ? '€ ' . number_format((float)$d['bedrag'], 2, ',', '.') 
                                : '—' ?>
                                <td><?= !empty($d['opmerkingen']) ? nl2br(htmlspecialchars($d['opmerkingen'])) : '—' ?></td>
                        </td>
                        <td><?= htmlspecialchars($d['stadium']) ?></td>
                        <td><?= htmlspecialchars($d['type']) ?></td>
                        <td><?= date('d-m-Y', strtotime($d['sluitingsdatum'])) ?></td>
                        <td><?= isset($contacts[$d['contact_id']]) ? htmlspecialchars($contacts[$d['contact_id']]['naam']) : '—' ?></td>
                        <td class="d-flex gap-1 flex-wrap">
                            <a href="bewerken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-warning">Bewerken</a>
                            <a href="verwijderen.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-danger">Verwijderen</a>
                            <a href="bekijken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-info">Details</a>
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    <?php endif ?>
</div>
</body>
</html>
