<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$order_id = $_GET['orderId'] ?? '';
if (empty($order_id)) {
    echo "❌ Geen orderId opgegeven.";
    exit;
}

$settings = require __DIR__ . '/settings.php';
$accounts = $settings['accounts'];

/**
 * Probeer producttitel op te halen via EAN uit catalogus.
 */
function haal_titel_op_via_ean($ean, $access_token) {
    if (empty($ean)) return null;

    $ch = curl_init("https://api.bol.com/retailer/catalog/products/$ean");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: application/vnd.retailer.v9+json",
        "Authorization: Bearer $access_token"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    return $data['title'] ?? null;
}

// Doorloop accounts om juiste token + orderdata te vinden
$order_data = null;
$gekozen_token = null;

foreach ($accounts as $label => $account) {
    // Token ophalen
    $ch = curl_init("https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/x-www-form-urlencoded",
        "Authorization: Basic " . base64_encode("{$account['client_id']}:{$account['client_secret']}")
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    $access_token = $data['access_token'] ?? '';
    if (!$access_token) continue;

    // Orderdetails ophalen
    $ch = curl_init("https://api.bol.com/retailer/orders/$order_id");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: application/vnd.retailer.v9+json",
        "Authorization: Bearer $access_token"
    ]);
    $order_response = curl_exec($ch);
    curl_close($ch);

    $decoded = json_decode($order_response, true);
    if (!empty($decoded['orderItems'])) {
        $order_data = $decoded;
        $gekozen_token = $access_token;
        break;
    }
}

if (empty($order_data)) {
    echo "⚠️ Geen ordergegevens gevonden in één van de accounts.";
    exit;
}

$total_price = 0.0;
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bestelling <?= htmlspecialchars($order_id) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, sans-serif;
            background-color: #f2f2f2;
            margin: 0;
            padding: 1rem;
        }

        .container {
            max-width: 700px;
            margin: auto;
            background: #fff;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.08);
        }

        h1 {
            font-size: 1.5rem;
            margin-bottom: 1rem;
            color: #222;
        }

        .product {
            padding: 1rem 0;
            border-bottom: 1px solid #eee;
        }

        .product-title {
            font-size: 1rem;
            font-weight: 500;
            color: #000;
        }

        .quantity {
            font-weight: bold;
            margin-right: 6px;
            color: #333;
        }

        .price {
            color: #555;
            font-size: 0.95rem;
            margin-top: 4px;
        }

        .ean {
            font-size: 0.85rem;
            color: #888;
        }

        .total {
            font-weight: bold;
            font-size: 1.1rem;
            text-align: right;
            margin-top: 2rem;
            padding-top: 1rem;
            border-top: 2px solid #eee;
            color: #222;
        }

        @media (max-width: 600px) {
            body {
                padding: 0.5rem;
            }

            .container {
                padding: 1rem;
            }

            h1 {
                font-size: 1.3rem;
            }

            .product-title {
                font-size: 0.95rem;
            }

            .total {
                font-size: 1rem;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Orderdetails</h1>
    <p><strong>Order ID:</strong> <?= htmlspecialchars($order_id) ?></p>

    <?php foreach ($order_data['orderItems'] as $item): 
        $title = null;

        if (!empty($item['product']['title'])) {
            $title = $item['product']['title'];
        } elseif (!empty($item['orderItemTitle'])) {
            $title = $item['orderItemTitle'];
        } elseif (!empty($item['offer']['title'])) {
            $title = $item['offer']['title'];
        } elseif (!empty($item['title'])) {
            $title = $item['title'];
        }

        if (empty($title) && !empty($item['ean']) && $gekozen_token) {
            $title = haal_titel_op_via_ean($item['ean'], $gekozen_token);
        }

        if (empty($title)) {
            $title = 'Onbekend product';
        }

        $title = htmlspecialchars($title);
        $quantity = $item['quantity'] ?? 1;
        $price = $item['unitPrice'] ?? 0;
        $total_price += $price * $quantity;
    ?>
        <div class="product">
            <div class="product-title">
                <span class="quantity"><?= $quantity ?>×</span><?= $title ?>
            </div>
            <div class="price">Prijs per stuk: €<?= number_format($price, 2, ',', '.') ?></div>
            <?php if (!empty($item['ean'])): ?>
                <div class="ean">EAN: <?= htmlspecialchars($item['ean']) ?></div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>

    <div class="total">
        Totale waarde: €<?= number_format($total_price, 2, ',', '.') ?>
    </div>
</div>
</body>
</html>
