<?php
// test_sound.php

$settings = require __DIR__ . '/settings.php';

$token = $settings['pushover']['app_token'];
$user = $settings['pushover']['user_key'];

$data = json_decode(file_get_contents('php://input'), true);
$sound = $data['sound'] ?? 'pushover';

if (!$token || !$user || !$sound) {
    http_response_code(400);
    echo "Incompleet verzoek";
    exit;
}

$post_fields = [
    'token' => $token,
    'user' => $user,
    'title' => "🔊 Testgeluid: " . ucfirst($sound),
    'message' => "Dit is een test van geluid '$sound'.",
    'priority' => 1,
    'sound' => $sound
];

$ch = curl_init("https://api.pushover.net/1/messages.json");
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

echo "Geluidstest '$sound' verzonden via Pushover.";
