<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

$settings = json_decode(file_get_contents(__DIR__ . '/settings.json'), true);

$user_key = $settings['pushover_user_key'];
$app_token = $settings['pushover_app_token'];
$client_id_1 = $settings['client_1_id'];
$client_secret_1 = $settings['client_1_secret'];
$client_id_2 = $settings['client_2_id'];
$client_secret_2 = $settings['client_2_secret'];
$html_notification = $settings['html_notification'];

function verwerk_bestellingen($client_id, $client_secret, $user_key, $app_token, $label, $html_notification) {
    $order_id_file = __DIR__ . "/last_bol_order_time_{$label}.txt";

    $ch = curl_init("https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/x-www-form-urlencoded",
        "Authorization: Basic " . base64_encode("$client_id:$client_secret")
    ]);
    $token_response = curl_exec($ch);
    curl_close($ch);

    $token_data = json_decode($token_response, true);
    $access_token = $token_data['access_token'] ?? null;

    if (!$access_token) {
        echo "❌ Geen access token voor account: $label<br>";
        return;
    }

    $last_order_time = file_exists($order_id_file) ? trim(file_get_contents($order_id_file)) : '';

    $ch = curl_init("https://api.bol.com/retailer/orders?status=OPEN");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Accept: application/vnd.retailer.v9+json",
        "Authorization: Bearer $access_token"
    ]);
    $orders_response = curl_exec($ch);
    curl_close($ch);

    $orders_data = json_decode($orders_response, true);

    if (!isset($orders_data['orders']) || empty($orders_data['orders'])) {
        echo "ℹ️ Geen openstaande orders voor account: $label<br>";
        return;
    }

    $newest_order = null;
    foreach ($orders_data['orders'] as $order) {
        if (is_null($newest_order) || $order['orderPlacedDateTime'] > $newest_order['orderPlacedDateTime']) {
            $newest_order = $order;
        }
    }

    if (is_null($newest_order)) {
        echo "ℹ️ Geen nieuwste order gevonden voor account: $label<br>";
        return;
    }

    $new_order_time = $newest_order['orderPlacedDateTime'];
    $new_order_id = $newest_order['orderId'];

    if ($new_order_time !== $last_order_time) {
        $ch = curl_init("https://api.bol.com/retailer/orders/$new_order_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Accept: application/vnd.retailer.v9+json",
            "Authorization: Bearer $access_token"
        ]);
        $details_response = curl_exec($ch);
        curl_close($ch);

        $details_data = json_decode($details_response, true);

        $total_price = 0.0;
        $product_list = "";
        if (isset($details_data['orderItems'])) {
            foreach ($details_data['orderItems'] as $item) {
                $unit_price = $item['unitPrice'] ?? 0;
                $quantity = $item['quantity'] ?? 1;
                $product_title = $item['orderItemTitle'] ?? 'Onbekend product';
                $total_price += ($unit_price * $quantity);
                $product_list .= "- {$quantity}x {$product_title}
";
            }
        }

        $sound = match (true) {
            $total_price < 7 => 'cashregister',
            $total_price < 20 => 'bike',
            $total_price < 50 => 'magic',
            default => 'siren'
        };

        $kort_bericht = "Order ID: $new_order_id
Totaal: €" . number_format($total_price, 2, ',', '.');
        $volledig_bericht = "Order ID: $new_order_id
Totaal: €" . number_format($total_price, 2, ',', '.') . "

Bestelde producten:
" . $product_list;

        $post_fields = [
            'token' => $app_token,
            'user' => $user_key,
            'title' => "Nieuwe Bol bestelling ($label)! 📦",
            'message' => $kort_bericht,
            'priority' => 1,
            'sound' => $sound,
            'html' => $html_notification ? 1 : 0,
            'url' => "data:text/plain," . urlencode($volledig_bericht),
            'url_title' => "Bekijk bestelling"
        ];

        $ch = curl_init("https://api.pushover.net/1/messages.json");
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($post_fields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_exec($ch);
        curl_close($ch);

        file_put_contents($order_id_file, $new_order_time);

        echo "✅ Order gemeld voor: $label<br>";
    } else {
        echo "ℹ️ Geen nieuwe orders voor $label<br>";
    }
}

verwerk_bestellingen($client_id_1, $client_secret_1, $user_key, $app_token, "NL", $html_notification);
verwerk_bestellingen($client_id_2, $client_secret_2, $user_key, $app_token, "BE", $html_notification);
