<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

$wachtwoord = "321";

// Login afhandelen
if (isset($_POST['wachtwoord'])) {
    if ($_POST['wachtwoord'] === $wachtwoord) {
        $_SESSION['ingelogd'] = true;
    } else {
        $foutmelding = "Verkeerd wachtwoord!";
    }
}

// Als niet ingelogd, toon login formulier
if (!isset($_SESSION['ingelogd'])) {
    ?>
    <form method="POST">
        <h2>Inloggen Voorraadbeheer</h2>
        <input type="password" name="wachtwoord" required>
        <button type="submit">Login</button>
    </form>
    <?php
    if (isset($foutmelding)) {
        echo "<p style='color:red;'>" . htmlspecialchars($foutmelding) . "</p>";
    }
    exit;
}

// Functie: Voorraad laden
function laadVoorraad() {
    $data = file('voorraad.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $voorraad = [];
    foreach ($data as $line) {
        list($product, $aantal) = explode("|", $line);
        $voorraad[trim($product)] = (int)trim($aantal);
    }
    return $voorraad;
}

// Functie: Voorraad opslaan
function opslaanVoorraad($voorraad) {
    $regels = [];
    foreach ($voorraad as $product => $aantal) {
        $regels[] = "$product|$aantal";
    }
    file_put_contents('voorraad.txt', implode("\n", $regels));
}

// Functie: Logboek bijwerken
function logboek($actie) {
    $tijd = date("Y-m-d H:i");
    file_put_contents('logboek.txt', "$tijd | $actie\n", FILE_APPEND);
}

// Bestanden checken
if (!file_exists('voorraad.txt')) {
    die('FOUT: voorraad.txt bestaat niet.');
}
if (!file_exists('logboek.txt')) {
    die('FOUT: logboek.txt bestaat niet.');
}

// Laad voorraad
$voorraad = laadVoorraad();

// Voorraad aanpassen
if (isset($_POST['actie'])) {
    $product = $_POST['product'];
    $aantal = (int)$_POST['aantal'];
    if ($_POST['actie'] === 'bijboeken') {
        $voorraad[$product] += $aantal;
        logboek("$aantal $product BIJGEBOEKT");
    } elseif ($_POST['actie'] === 'afboeken') {
        $voorraad[$product] -= $aantal;
        logboek("$aantal $product AFGEBOEKT");
    }
    opslaanVoorraad($voorraad);
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Geschiedenis inladen
$geschiedenis = file_exists('logboek.txt') ? file('logboek.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];

?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Voorraadbeheer Bio-Suds</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<div class="mb-4">
    <a href="https://bio-suds.nl/voorraad/statistieken.php" class="btn btn-outline-primary">📊 Ga naar Statistieken</a>
</div>
<body class="p-4">
<div class="container">
    <h1>Voorraadbeheer Bio-Suds</h1>

    <h2>Huidige Voorraad</h2>
    <table class="table table-bordered">
        <thead><tr><th>Product</th><th>Voorraad</th></tr></thead>
        <tbody>
        <?php foreach ($voorraad as $product => $aantal) { ?>
            <tr><td><?php echo htmlspecialchars($product); ?></td><td><?php echo htmlspecialchars($aantal); ?></td></tr>
        <?php } ?>
        </tbody>
    </table>

    <h2>Voorraad aanpassen</h2>
    <form method="POST" class="row g-3 mb-5">
        <div class="col-md-4">
            <select name="product" class="form-control">
                <option value="vaatwasstrip">Vaatwasstrip</option>
                <option value="wasstrip">Wasstrip</option>
            </select>
        </div>
        <div class="col-md-4">
            <input type="number" name="aantal" class="form-control" placeholder="Aantal" required>
        </div>
        <div class="col-md-4">
            <button name="actie" value="bijboeken" class="btn btn-success">Bijboeken</button>
            <button name="actie" value="afboeken" class="btn btn-danger">Afboeken</button>
        </div>
    </form>
<form method="GET" class="mb-3">
    <label>Filter op datum:</label>
    <input type="date" name="filterdatum" value="<?php echo htmlspecialchars($_GET['filterdatum'] ?? ''); ?>">
    <button type="submit" class="btn btn-primary btn-sm">Filteren</button>
    <a href="index.php" class="btn btn-secondary btn-sm">Reset</a>
</form>
    <h2>Geschiedenis</h2>
 <?php
$totaal_verkocht = 0;
?>
<table class="table table-striped">
    <thead><tr><th>Datum/Tijd</th><th>Actie</th></tr></thead>
    <tbody>
    <?php
    foreach (array_reverse($geschiedenis) as $regel) {
        list($tijd, $actie) = explode('|', $regel, 2);

        // Filteren op gekozen datum (optioneel)
        if (isset($_GET['filterdatum']) && $_GET['filterdatum'] != '') {
            $filterdatum = $_GET['filterdatum'];
            if (strpos($tijd, $filterdatum) !== 0) {
                continue; // sla over als datum niet matcht
            }
        }

        // Bepalen hoeveel strips zijn verkocht bij deze regel
   // Bepalen hoeveel strips zijn verkocht of afgeboekt bij deze regel
if (preg_match('/(\\d+) vaatwasstrip/', $actie, $matches)) {
    $totaal_verkocht += (int)$matches[1];
}
if (preg_match('/(\\d+) wasstrip/', $actie, $matches)) {
    $totaal_verkocht += (int)$matches[1];
}

    ?>
        <tr>
            <td><?php echo htmlspecialchars(trim($tijd)); ?></td>
            <td><?php echo htmlspecialchars(trim($actie)); ?></td>
        </tr>
    <?php } ?>
    </tbody>
</table>

<?php if (isset($_GET['filterdatum']) && $_GET['filterdatum'] != '') { ?>
    <div class="alert alert-info">
        ðŸ”¹ Totaal aantal strips verkocht op <?php echo htmlspecialchars($_GET['filterdatum']); ?>: <strong><?php echo $totaal_verkocht; ?></strong> stuks
    </div>
<?php } ?>



</div>
</body>
</html>
