<?php
date_default_timezone_set('Europe/Amsterdam');

function getDeliveryMessage() {
    $now = new DateTime('now', new DateTimeZone('Europe/Amsterdam'));
    $hour = (int)$now->format('H');
    $dayOfWeek = (int)$now->format('w'); // 0 = zondag, 1 = maandag, ..., 6 = zaterdag

    // Volgend heel uur (cutoff)
    $nextHour = ($hour + 1) % 24;
    $cutoffTime = sprintf("%02d:00", $nextHour);

    // Bereken leverdag
    $deliveryDay = nextBusinessDay($dayOfWeek, $hour);

    return "Voor <strong>{$cutoffTime}</strong> besteld = <strong>{$deliveryDay}</strong> in huis";
}

function nextBusinessDay($day, $hour) {
    // Weekdagen 0–6 (zo–za)
    // Maandag = geen levering, alleen ophalen → dinsdag in huis
    // Vrijdag na 17:00, zaterdag en zondag → dinsdag in huis
    // Alle andere werkdagen → volgende dag levering

    if ($day == 1) return "dinsdag"; // maandag → dinsdag
    if ($day == 5 && $hour >= 17) return "dinsdag"; // vrijdagavond → dinsdag
    if ($day == 6) return "dinsdag"; // zaterdag → dinsdag
    if ($day == 0) return "dinsdag"; // zondag → dinsdag

    // Standaard volgende dag (normaal werkdag)
    $days = [
        1 => "dinsdag",
        2 => "woensdag",
        3 => "donderdag",
        4 => "vrijdag",
        5 => "zaterdag"
    ];
    return $days[$day] ?? "dinsdag";
}
?>



<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bio-Suds – Samengesteld Proefpakket</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

<header class="topbar white-header">
    <div class="container">
        <img src="https://www.bio-suds.com/cdn/shop/files/bio_logo.png" alt="Bio-Suds logo" class="site-logo">
    </div>
</header>

<main class="shopify-layout">

    <!-- Linkerzijde: productafbeelding -->
    <div class="product-gallery">
        <div class="main-image">
            <img id="mainPhoto" src="https://www.bio-suds.com/cdn/shop/files/bio_suds_vaatwas.png?v=1734464722&width=823" alt="Bio-Suds hoofdafbeelding">
        </div>

        <div class="thumbnail-slider">
            <img src="https://www.bio-suds.com/cdn/shop/files/1_4f2471af-9924-4c6c-9a6f-cbe8505d72de.png?v=1746972772&width=823" alt="Wasstrips" onclick="changeImage(this)">
            <img src="https://www.bio-suds.com/cdn/shop/files/biosudsvaatwas_3.webp?v=1734464722&width=823" alt="Product closeup" onclick="changeImage(this)">
            <img src="https://www.bio-suds.com/cdn/shop/files/biogoedbol_1.png?v=1746972772&width=823" alt="Verpakking" onclick="changeImage(this)">
            <img src="https://www.bio-suds.com/cdn/shop/files/biogoedbol_3.png?v=1734464722&width=823" alt="Bio-Good bol" onclick="changeImage(this)">
                        <img src="https://www.bio-suds.com/cdn/shop/files/bio_suds_vaatwas.png?v=1734464722&width=823" alt="Bio-Good bol" onclick="changeImage(this)">
        </div>
    </div>

    <!-- Rechterzijde: tekst + pakketten -->
    <div class="product-info">
        <h1>Ontdek ons duurzaam duo proefpakket met alleen vandaag 50% korting!</h1>

        <!-- ✅ Trustpilot badge -->
<a href="https://www.trustpilot.com/review/bio-suds.com?languages=nl&sort=recency" 
   target="_blank" 
   rel="noopener noreferrer" 
   class="trustpilot-badge">
    <img src="https://i.imgur.com/EHjNmTM.png" alt="Trustpilot 4.7" class="trustpilot-logo">
    <span class="trust-text">Trustpilot score: <strong>4,7 / 5</strong></span>
</a>


        <ul class="usp-list">
<li>🚚 <?php echo getDeliveryMessage(); ?></li>
            <li>📦 Gratis verzending bij bestellingen vanaf €20</li>
            <li>🕒 100 dagen bedenktijd</li>
            <li>💰 Niet tevreden? Geld terug</li>
        </ul>

        <p class="stock-warning">
            ⚠️ Bijna uitverkocht! Slechts 4 proefpakketten beschikbaar tegen deze introductieprijs.<br>
            🔥 Let op: Er zijn nu <strong>4 mensen</strong> aan het afrekenen.
        </p>

        <hr>

<h3 class="pakket-titel">Kies je pakket</h3>

<form class="pakket-form">

    <!-- Klein proefpakket -->
    <label class="pakket-box">
        <input type="radio" name="pakket" value="klein" checked>
        <div class="pakket-content">
            <div class="pakket-header">
                <span class="badge green">+ Verzendkosten</span>
            </div>
            <div class="pakket-body">
                <p class="pakket-naam">Klein proefpakket</p>
                <p class="pakket-info">16 proefwasjes + 16 vaatwasjes</p>
                <div class="prijs-box">
                    <span class="nieuwe-prijs">€14,95</span>
                </div>
            </div>
        </div>
    </label>

    <!-- Normaal proefpakket -->
    <label class="pakket-box">
        <input type="radio" name="pakket" value="normaal">
        <div class="pakket-content">
            <div class="pakket-header">
                <span class="korting-tag">15% KORTING</span>
            </div>
            <div class="pakket-body">
                <p class="pakket-naam">Normaal proefpakket</p>
                <p class="pakket-info">30 proefwasjes + 30 vaatwasjes</p>
                <div class="prijs-box">
                    <span class="oude-prijs">€23,50</span>
                    <span class="nieuwe-prijs">€19,95</span>
                </div>
            </div>
        </div>
    </label>

<!-- Groot proefpakket -->
<label class="pakket-box highlight">
    <input type="radio" name="pakket" value="groot" checked>
        <div class="pakket-content">
            <div class="pakket-header">
                <span class="badge green">+ GRATIS VERZENDING! 🚚</span>
                <span class="korting-tag">30% KORTING</span>
            </div>
            <div class="pakket-body">
                <p class="pakket-naam">Groot proefpakket</p>
                <p class="pakket-info">60 proefwasjes + 60 vaatwasjes</p>
                <div class="prijs-box">
                    <span class="oude-prijs">€49,95</span>
                    <span class="nieuwe-prijs">€34,95</span>
                </div>
            </div>
        </div>
    </label>

    <!-- Slim inkopen -->
    <label class="pakket-box">
        <input type="radio" name="pakket" value="slim">
        <div class="pakket-content">
            <div class="pakket-header">
                <span class="badge box">+ 2 bewaarboxen 📦</span>
                <span class="korting-tag">50% KORTING</span>
            </div>
            <div class="pakket-body">
                <p class="pakket-naam">Grote wasser – slim inkopen</p>
                <p class="pakket-info">120 vaatwasjes + 120 wasjes</p>
                <div class="prijs-box">
                    <span class="oude-prijs">€119,90</span>
                    <span class="nieuwe-prijs">€59,95</span>
                </div>
            </div>
        </div>
    </label>

    <button type="submit" class="cta-button full">Bestellen</button>
</form>

    </div>
</main>

<!-- Productbeschrijving onder pakketten -->
<section class="product-description">
    <div class="container">
        <h2>Over dit proefpakket</h2>
        <p>Ben je benieuwd naar de milieuvriendelijke schoonmaakproducten van Bio-Suds? Dit is je kans! Ontdek de kracht van onze <strong>Bio-Suds Vaatwasstrips</strong> en <strong>Biologische Wasstrips</strong> in een speciaal samengesteld proefpakket.</p>

        <p><strong>Bio-Suds Milieuvriendelijke Vaatwasstrips:</strong> Dé plasticvrije manier om je vaat stralend schoon te krijgen.<br>
        <strong>Bio-Suds Milieuvriendelijke Wasstrips:</strong> De perfecte, compacte oplossing voor jouw wasgoed. Zacht voor je huid, krachtig tegen vlekken en volledig biologisch afbreekbaar.</p>

        <p class="highlight-offer">🌿 <strong>Exclusieve aanbieding:</strong> Bestel nu een proefpakket – <u>alleen vandaag 50% korting!</u> Dit is jouw kans om duurzaam wassen en afwassen zelf te ervaren.</p>

        <h3>Bio-Suds – Milieuvriendelijke Vaatwasstrips</h3>
        <ul>
            <li>🌍 <strong>Plasticvrij:</strong> Geen plastic verpakking of microplastics in het water.</li>
            <li>✨ <strong>Krachtige reiniging:</strong> Lost op bij lage temperaturen, verwijdert vet en etensresten moeiteloos.</li>
            <li>📦 <strong>Compact:</strong> Lichtgewicht en ruimtebesparend in je keukenkast.</li>
            <li>👌 <strong>Makkelijk in gebruik:</strong> Leg een strip in de vaatwasser, klaar!</li>
            <li>❌ <strong>Vrij van chemicaliën:</strong> Geen fosfaten of bleekmiddelen.</li>
        </ul>

        <h3>Bio-Suds – Milieuvriendelijke Wasstrips</h3>
        <ul>
            <li>🌱 <strong>100% biologisch afbreekbaar:</strong> Lost volledig op in water, geen microplastics.</li>
            <li>🧺 <strong>Zacht voor de huid:</strong> Hypoallergeen, perfect voor gevoelige huid.</li>
            <li>🏠 <strong>Compact:</strong> Ideaal voor thuis of op reis.</li>
            <li>💪 <strong>Krachtig tegen vlekken:</strong> Zelfs bij lage temperaturen effectief.</li>
            <li>♻️ <strong>Plasticvrij verpakt:</strong> Geen plastic flessen – beter voor onze planeet.</li>
        </ul>

        <p class="closing-text">Met Bio-Suds kies je voor gemak, duurzaamheid en kwaliteit in één. Probeer het zelf en ervaar hoe eenvoudig en effectief duurzaam schoonmaken kan zijn!</p>
    </div>
</section>
<?php include 'footer.php'; ?>


<script>
function changeImage(img) {
    document.getElementById("mainPhoto").src = img.src;
}
</script>
<script src="https://js.stripe.com/v3/"></script>
<script>
document.addEventListener("DOMContentLoaded", function() {

    // ✅ 1. Stripe initialiseren
    const stripe = Stripe("pk_live_51QXMd8AKrSoa5UcPktiizzHHyA108rQd2SZKEMUkQyfjvAXlQWrk701uZ9Y7cLcXFs8hzyh4MOmPBUkesM5JWjY2004RD6CD4X"); // <-- vervang met jouw eigen PUBLISHABLE key

    // ✅ 2. Knop ophalen
    const button = document.querySelector(".cta-button.full");

    if (!button) {
        console.error("Stripe knop niet gevonden op de pagina.");
        return;
    }

    // ✅ 3. Klik event toevoegen
    button.addEventListener("click", async (e) => {
        e.preventDefault();

        const selected = document.querySelector('input[name="pakket"]:checked');
        if (!selected) {
            alert("Kies eerst een pakket voordat je doorgaat naar betalen.");
            return;
        }

        const pakket = selected.value;

        try {
            // ✅ 4. Stuur pakket naar checkout.php
            const response = await fetch("checkout.php", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ pakket })
            });

            if (!response.ok) {
                const text = await response.text();
                throw new Error("Serverfout: " + text);
            }

            const session = await response.json();

            if (!session.id) {
                console.error("Stripe sessie ongeldig:", session);
                alert("Er ging iets mis bij het starten van de betaling.");
                return;
            }

            // ✅ 5. Redirect naar Stripe Checkout
            const result = await stripe.redirectToCheckout({
                sessionId: session.id
            });

            if (result.error) {
                alert(result.error.message);
            }

        } catch (err) {
            console.error("Fout tijdens Stripe-proces:", err);
            alert("Kon geen verbinding maken met de betaalserver. Probeer het opnieuw.");
        }
    });
});
</script>

</body>
</html>
