<?php
session_start();
require_once 'config.php';
if (!$_SESSION['logged_in']) die("Niet ingelogd.");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Webmail Dashboard</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body { font-family: sans-serif; margin: 0; display: flex; height: 100vh; }
        .sidebar { width: 250px; background: #f2f2f2; padding: 20px; box-shadow: 2px 0 5px #ccc; }
        .sidebar h2 { font-size: 18px; }
        .sidebar ul { list-style: none; padding: 0; }
        .sidebar li { margin-bottom: 10px; }
        .sidebar a { text-decoration: none; color: #333; display: block; padding: 8px; border-radius: 5px; }
        .sidebar a:hover { background: #ddd; }
        .content { flex-grow: 1; padding: 20px; overflow-y: auto; }
        .mail-table { width: 100%; border-collapse: collapse; }
        .mail-table th, .mail-table td { padding: 10px; border-bottom: 1px solid #eee; text-align: left; }
        .mail-row:hover { background: #f9f9f9; cursor: pointer; }
        .mail-view { border: 1px solid #ddd; padding: 15px; margin-top: 20px; display: none; }
        .mail-view h3 { margin-top: 0; }
        .button { display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; margin-top: 10px; }
        .logout { color: red; display: inline-block; margin-top: 30px; }
    </style>
</head>
<body>
<div class="sidebar">
    <h2>Mailboxen</h2>
    <ul>
        <?php foreach ($mailboxes as $label => $_): ?>
            <li><a href="#" onclick="loadMailbox('<?= $label ?>'); return false;"><?= $label ?></a></li>
        <?php endforeach; ?>
    </ul>
    <a class="button" href="send.php">📤 Nieuwe mail</a>
    <a class="logout" href="logout.php">🔒 Uitloggen</a>
</div>
<div class="content">
    <h1>Inbox</h1>
    <div id="mailboxContent">Klik op een mailbox om e-mails te laden...</div>
    <div id="mailView" class="mail-view"></div>
</div>

<script>
function loadMailbox(mailbox) {
    fetch('load_mailbox.php?mailbox=' + encodeURIComponent(mailbox))
        .then(res => res.text())
        .then(html => {
            document.getElementById('mailboxContent').innerHTML = html;
            document.getElementById('mailView').style.display = 'none';
        });
}

function openMail(mailbox, uid) {
    fetch('read_mail.php?mailbox=' + encodeURIComponent(mailbox) + '&uid=' + uid)
        .then(res => res.text())
        .then(html => {
            document.getElementById('mailView').innerHTML = html;
            document.getElementById('mailView').style.display = 'block';
        });
}
</script>
</body>
</html>
