<?php
require_once 'config.php';
require_once 'imap_functions.php';

$mailbox = $_GET['mailbox'] ?? '';
if (!isset($mailboxes[$mailbox])) die("Ongeldige mailbox");

$box = $mailboxes[$mailbox];
$snoozedData = file_exists('snoozed.json') ? json_decode(file_get_contents('snoozed.json'), true) : [];
$now = time();
$activeSnoozed = [];

foreach ($snoozedData as $uid => $info) {
    if (strtotime($info['until']) > $now && $info['mailbox'] === $mailbox) {
        $activeSnoozed[] = (int)$uid;
    }
}

$emails = fetchEmails($box, $activeSnoozed);

echo "<table class='mail-table'>";
echo "<tr><th>Van</th><th>Onderwerp</th><th>Datum</th></tr>";
foreach ($emails as $mail) {
    echo "<tr class='mail-row' onclick=\"openMail('$mailbox', {$mail['uid']})\">";
    echo "<td>" . htmlspecialchars($mail['from']) . "</td>";
    echo "<td>" . htmlspecialchars($mail['subject']) . "</td>";
    echo "<td>" . htmlspecialchars($mail['date']) . "</td>";
    echo "</tr>";
}
echo "</table>";
?>
