<?php
// Error reporting
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('Europe/Amsterdam');  // Zet de tijdzone naar Amsterdam

// API-gegevens Shopify
$shopify_api_key = "6a9c5793afda64320735c89f00c4d264";
$shopify_secret = "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";
$shopify_shop_url = "35787f-3.myshopify.com";

// API-gegevens Bol.com
$bol_client_id = "df44d7d8-4979-42cf-a1dd-a2ba38b5dbfd";
$bol_client_secret = "0jO1Phg?3BgI)KmoCIJByrhxUlamIvhrEC9cUPmK8(MvC1GeF@2GOap4BcESAXEx";

// Functies
function laadVoorraad() {
    $data = file('voorraad.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $voorraad = [];
    foreach ($data as $line) {
        list($product, $aantal) = explode("|", $line);
        $voorraad[trim($product)] = (int)trim($aantal);
    }
    return $voorraad;
}

function opslaanVoorraad($voorraad) {
    $regels = [];
    foreach ($voorraad as $product => $aantal) {
        $regels[] = "$product|$aantal";
    }
    file_put_contents('voorraad.txt', implode("\n", $regels));
}

function logboek($actie) {
    date_default_timezone_set('Europe/Amsterdam');
    $tijd = date("Y-m-d H:i");
    file_put_contents('logboek.txt', "$tijd | $actie\n", FILE_APPEND);
}

function verwerkSKU($sku, &$voorraad, $ordernummer = '') {
    $sku = strtolower($sku);

    if (strpos($sku, 's') !== false) {
        list($v, $w) = explode('s', $sku);
        $voorraad['vaatwasstrip'] -= (int)$v;
        $voorraad['wasstrip'] -= (int)$w;
        logboek("Bestelling $ordernummer | $v vaatwasstrips en $w wasstrips verkocht (S-type)");
    } elseif (strpos($sku, 'e') !== false) {
        $voorraad['vaatwasstrip'] -= 3;
        $voorraad['wasstrip'] -= 3;
        logboek("Bestelling $ordernummer | 3 vaatwasstrips en 3 wasstrips verkocht (E-type)");
    } elseif (substr($sku, -1) === 'v') {
        $aantal = (int)str_replace('v', '', $sku);
        $voorraad['vaatwasstrip'] -= $aantal;
        logboek("Bestelling $ordernummer | $aantal vaatwasstrips verkocht");
    } elseif (substr($sku, -1) === 'w') {
        $aantal = (int)str_replace('w', '', $sku);
        $voorraad['wasstrip'] -= $aantal;
        logboek("Bestelling $ordernummer | $aantal wasstrips verkocht");
    }
}

// Shopify orders ophalen
function fetchShopifyOrders($shop_url, $access_token) {
    $url = "https://$shop_url/admin/api/2023-07/orders.json";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "X-Shopify-Access-Token: $access_token"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Bol.com orders ophalen
function fetchBolOrders($client_id, $client_secret) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $client_id . ":" . $client_secret);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    if (!isset($result['access_token'])) {
        die("Kan geen access token ophalen van Bol.com");
    }
    $access_token = $result['access_token'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.bol.com/retailer/orders");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "Accept: application/vnd.retailer.v9+json"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Tweede Bol.com account orders ophalen
function fetchBolOrders2() {
    $client_id = "a6fc9a12-7ba4-41b9-aa6f-8aaae16a3f1f";
    $client_secret = "Wuhc9KXlNxQrnpVvnXQKthzmaIh3R6gq!TO7xsg3FF@0oOd@ljS)Mip0e@Kv(bYi";

    // Access token ophalen
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://login.bol.com/token");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_USERPWD, $client_id . ":" . $client_secret);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);
    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);
    if (!isset($result['access_token'])) {
        die("Kan geen access token ophalen van Bol.com Account 2");
    }
    $access_token = $result['access_token'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.bol.com/retailer/orders");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Authorization: Bearer $access_token",
        "Accept: application/vnd.retailer.v9+json"
    ]);
    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}

// Verwerkte orders laden
$verwerkte_orders = file_exists('verwerkt_orders.txt') ? file('verwerkt_orders.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];

function markeerAlsVerwerkt($ordernummer) {
    file_put_contents('verwerkt_orders.txt', $ordernummer . "\n", FILE_APPEND);
}

// Start sync
$voorraad = laadVoorraad();

// Shopify orders ophalen
$shopify_orders = fetchShopifyOrders($shopify_shop_url, $shopify_secret);

if (isset($shopify_orders['orders'])) {
    foreach ($shopify_orders['orders'] as $order) {
        $ordernummer = $order['name'];
        if (in_array($ordernummer, $verwerkte_orders)) {
            continue; // skip deze order, al verwerkt
        }
        foreach ($order['line_items'] as $item) {
            if (isset($item['sku']) && $item['sku'] != '') {
                verwerkSKU($item['sku'], $voorraad, $ordernummer);
            }
        }
        markeerAlsVerwerkt($ordernummer);
    }
}

// Mapping van EAN naar SKU
$ean_to_sku = [
    // Vaatwasstrips
    "8721249913006" => "5v",
    "8720872310480" => "5v",
    "8721249913099" => "30v",
    "8721249913013" => "60v",
    "8720872310503" => "60v",
    "8721249913020" => "120v",
    "8721249913082" => "180v",

    // Wasstrips
    "8721249913037" => "5w",
    "8721249913112" => "30w",
    "8720872310435" => "30w",
    "8721249913044" => "60w",
    "8721249913105" => "120w",
    "8721249913143" => "180w",
    
    // Combi (5-5 en 15-15)
    "8720872310473" => "5s5",  // Combi 5-5 (5 vaatwasstrips en 5 wasstrips)
    "8721249913051" => "5s5",  // Combi 5-5 (5 vaatwasstrips en 5 wasstrips)
    "8721249913136" => "15s15", // Combi 15-15 (15 vaatwasstrips en 15 wasstrips)
];

// Bol.com orders
$bol_orders = fetchBolOrders($bol_client_id, $bol_client_secret);

// Verwerken van Bol.com orders
if (isset($bol_orders['orders'])) {
    foreach ($bol_orders['orders'] as $order) {
        $ordernummer = $order['orderId'];
        if (in_array($ordernummer, $verwerkte_orders)) {
            continue; // skip deze order
        }
        if (isset($order['orderItems'])) {
            foreach ($order['orderItems'] as $item) {
                if (isset($item['ean']) && $item['ean'] != '') {
                    $ean = $item['ean'];
                    if (isset($ean_to_sku[$ean])) {
                        $sku = $ean_to_sku[$ean];
                        verwerkSKU($sku, $voorraad, $ordernummer);
                    } else {
                        logboek("Onbekende EAN bij Bol.com order $order: ean $ean");
                    }
                }
            }
        }
        markeerAlsVerwerkt($ordernummer);
    }
}

// Bol.com account 2 orders ophalen en verwerken
$bol_orders_2 = fetchBolOrders2();

if (isset($bol_orders_2['orders'])) {
    foreach ($bol_orders_2['orders'] as $order) {
        $ordernummer = $order['orderId'];
        if (in_array($ordernummer, $verwerkte_orders)) {
            continue; // skip deze order
        }
        if (isset($order['orderItems'])) {
            foreach ($order['orderItems'] as $item) {
                if (isset($item['ean']) && $item['ean'] != '') {
                    $ean = $item['ean'];
                    if (isset($ean_to_sku[$ean])) {
                        $sku = $ean_to_sku[$ean];
                        verwerkSKU($sku, $voorraad, $ordernummer);
                    } else {
                        logboek("Onbekende EAN bij Bol.com 2 order: $ean");
                    }
                }
            }
        }
        markeerAlsVerwerkt($ordernummer);
    }
}

// Voorraad opslaan
opslaanVoorraad($voorraad);

echo "Sync afgerond!";
?>
